package ru.yandex.direct.mysql.ytsync.common.compatibility;

import java.util.Optional;

import ru.yandex.direct.mysql.ytsync.common.row.FlatRow;
import ru.yandex.inside.yt.kosher.impl.ytree.object.YTreeSerializer;
import ru.yandex.inside.yt.kosher.tables.YTableEntryType;
import ru.yandex.inside.yt.kosher.tables.types.YTreeObjectEntryType;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;
import ru.yandex.type_info.TiType;
import ru.yandex.yson.YsonConsumer;
import ru.yandex.yt.ytclient.tables.TableSchema;

public class KosherFlatRowDeserializer implements YTreeSerializer<FlatRow> {
    private final TableSchema schema;

    public KosherFlatRowDeserializer(TableSchema schema) {
        this.schema = schema;
    }

    @Override
    public void serialize(FlatRow obj, YsonConsumer consumer) {
        throw new IllegalStateException("Deserializer cannot be used to serialize data");
    }

    @Override
    public FlatRow deserialize(YTreeNode node) {
        ru.yandex.inside.yt.kosher.ytree.YTreeMapNode map = node.mapNode();
        FlatRow row = new FlatRow(schema.getColumnsCount());
        for (int i = 0; i < schema.getColumnsCount(); i++) {
            Optional<YTreeNode> value = map.get(schema.getColumnName(i));
            if (value.isPresent()) {
                row.set(i, value.get());
            }
        }
        return row;
    }

    public YTableEntryType<FlatRow> toEntryType() {
        return new YTreeObjectEntryType<>(this);
    }

    @Override
    public TiType getColumnValueType() {
        return TiType.optional(TiType.yson());
    }
}
