package ru.yandex.direct.mysql.ytsync.common.compatibility;

import ru.yandex.direct.mysql.ytsync.common.row.FlatRowView;
import ru.yandex.inside.yt.kosher.impl.ytree.YTreeNodeUtils;
import ru.yandex.inside.yt.kosher.impl.ytree.object.YTreeRowSerializer;
import ru.yandex.inside.yt.kosher.tables.YTableEntryType;
import ru.yandex.inside.yt.kosher.tables.types.YTreeObjectEntryType;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;
import ru.yandex.type_info.TiType;
import ru.yandex.yson.YsonConsumer;
import ru.yandex.yt.ytclient.tables.TableSchema;

/**
 * Сериализация FlatRow напрямую в kosher клиент
 */
public class KosherFlatRowSerializer<T extends FlatRowView> implements YTreeRowSerializer<T> {
    private final TableSchema schema;

    public KosherFlatRowSerializer(TableSchema schema) {
        this.schema = schema;
    }

    @Override
    public void serialize(T obj, YsonConsumer consumer) {
        if (obj.size() > schema.getColumnsCount()) {
            throw new IllegalStateException("FlatRow has more columns than a schema");
        }
        consumer.onBeginMap();
        for (int i = 0; i < obj.size(); i++) {
            YTreeNode value = obj.get(i);
            if (value != null) {
                consumer.onKeyedItem(schema.getColumnName(i));
                YTreeNodeUtils.walk(obj.get(i), consumer, true);
            }
        }
        consumer.onEndMap();
    }

    @Override
    public void serializeRow(T obj, YsonConsumer consumer, boolean keyFieldsOnly,
                             T compareWith) {
        serialize(obj, consumer);
    }

    @Override
    public T deserialize(YTreeNode node) {
        throw new IllegalStateException("Serializer cannot be used to deserialize data");
    }

    public YTableEntryType<T> toEntryType() {
        return new YTreeObjectEntryType<>(this);
    }

    @Override
    public TiType getColumnValueType() {
        return TiType.optional(TiType.yson());
    }
}
