package ru.yandex.direct.mysql.ytsync.common.compatibility;

import java.util.concurrent.CompletableFuture;

/**
 * Лок в кипарисе на yt
 */
public interface YtLock {
    /**
     * Отмена лока
     */
    CompletableFuture<Void> cancel();

    /**
     * Возвращает true, если лок находится в состоянии acquired
     * <p>
     * Актуально для waitable локов
     */
    CompletableFuture<Boolean> acquired();

    /**
     * Завершается на разблокировке лока (успешном добровольном или из-за ошибки)
     */
    CompletableFuture<Void> unlocked();
}
