package ru.yandex.direct.mysql.ytsync.common.compatibility;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.direct.mysql.ytsync.common.keys.PivotKeys;
import ru.yandex.direct.ytwrapper.model.attributes.OptimizeForAttr;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;
import ru.yandex.yt.ytclient.tables.TableSchema;

/**
 * Реализация YtSupport через делегацию вызовов в другой YtSupport
 */
public class YtSupportDelegate extends YtSupportDelegateToBasic {
    public YtSupportDelegate(YtSupport base) {
        super(base);
    }

    @Override
    protected YtSupport base() {
        return (YtSupport) super.base();
    }

    @Override
    public <T> CompletableFuture<T> runTransaction(
            Function<? super YtSupport.Transaction, ? extends CompletableFuture<T>> fn) {
        return base().runTransaction(fn);
    }

    @Override
    public CompletableFuture<TableSchema> getTableSchema(String path) {
        return base().getTableSchema(path);
    }

    @Override
    public CompletableFuture<Pair<TableSchema, Boolean>> getTableSchemaAndIsDynamic(String path) {
        return base().getTableSchemaAndIsDynamic(path);
    }

    @Override
    public CompletableFuture<PivotKeys> getTablePivotKeys(String path) {
        return base().getTablePivotKeys(path);
    }

    @Override
    public CompletableFuture<Boolean> areTabletStatesEqual(String path, String state) {
        return base().areTabletStatesEqual(path, state);
    }

    @Override
    public CompletableFuture<String> getTabletState(String path) {
        return base().getTabletState(path);
    }

    @Override
    public CompletableFuture<Void> waitTabletStates(String path, String state) {
        return base().waitTabletStates(path, state);
    }

    @Override
    public CompletableFuture<Boolean> isTableMounted(String path) {
        return base().isTableMounted(path);
    }

    @Override
    public CompletableFuture<Void> waitTableMounted(String path) {
        return base().waitTableMounted(path);
    }

    @Override
    public CompletableFuture<Boolean> isTableUnmounted(String path) {
        return base().isTableUnmounted(path);
    }

    @Override
    public CompletableFuture<Void> waitTableUnmounted(String path) {
        return base().waitTableUnmounted(path);
    }

    @Override
    public CompletableFuture<Boolean> isTableDynamic(String path) {
        return base().isTableDynamic(path);
    }

    @Override
    public CompletableFuture<Void> maybeReshardAndMount(String path, PivotKeys pivotKeys) {
        return base().maybeReshardAndMount(path, pivotKeys);
    }

    @Override
    public CompletableFuture<Void> prepareDynamicTable(String path, TableSchema schema, OptimizeForAttr optimizeFor,
                                                       PivotKeys pivotKeys, Map<String, YTreeNode> attributes) {
        return base().prepareDynamicTable(path, schema, optimizeFor, pivotKeys, attributes);
    }
}
