package ru.yandex.direct.mysql.ytsync.common.compatibility;

import java.util.concurrent.CompletableFuture;

/**
 * Делегирует часть методов в BasicYtSupport
 */
public abstract class YtSupportDelegateToBasic extends BasicYtSupportDelegate implements YtSupport {
    protected YtSupportDelegateToBasic(BasicYtSupport base) {
        super(base);
    }

    @Override
    public CompletableFuture<? extends Transaction> nullTransaction() {
        return base().nullTransaction().thenApply(this::wrapTransaction);
    }

    @Override
    public CompletableFuture<? extends Transaction> startTransaction() {
        return base().startTransaction().thenApply(this::wrapTransaction);
    }

    @Override
    protected Transaction wrapTransaction(BasicTransaction tx) {
        return new TransactionDelegate(tx);
    }

    protected class TransactionDelegate extends BasicTransactionDelegate implements Transaction {
        public TransactionDelegate(BasicTransaction base) {
            super(base);
        }

        @Override
        public YtSupport support() {
            return YtSupportDelegateToBasic.this;
        }
    }
}
