package ru.yandex.direct.mysql.ytsync.common.compatibility;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

/**
 * Обёртка над YtSupport, добавляющая повторы для вызова runTransaction
 */
public class YtSupportWithRunTxRetries extends YtSupportDelegate {
    private final Duration timeout;

    public YtSupportWithRunTxRetries(YtSupport base, Duration timeout) {
        super(base);
        this.timeout = timeout;
    }

    @Override
    public <T> CompletableFuture<T> runTransaction(
            Function<? super YtSupport.Transaction, ? extends CompletableFuture<T>> fn) {
        return OperationWithRetries.start(() -> {
            // Мы не вызываем super.runTransaction(fn), т.к. иначе будет вызываться
            // неделегированный startTransaction, и support() будет протекать
            // возвращая оригинальный объект, а не нашу обёртку.
            return YtSupportUtil.runBasicTransaction(startTransaction(), fn, executor());
        }, executor(), timeout, false);
    }
}
