package ru.yandex.direct.mysql.ytsync.common.model;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Модель для хранения Json строки.
 * Используется для отличия обычной строки от json (для последующей конвертации в yson) при синхронизации в Yt таблицу
 */
@ParametersAreNonnullByDefault
public class JsonString {
    private final String jsonString;

    public JsonString(String jsonString) {
        this.jsonString = jsonString;
    }

    public String getJsonString() {
        return jsonString;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        JsonString that = (JsonString) o;
        return Objects.equals(jsonString, that.jsonString);
    }

    @Override
    public int hashCode() {
        return Objects.hash(jsonString);
    }
}
