package ru.yandex.direct.mysql.ytsync.common.row;

import java.util.AbstractList;
import java.util.RandomAccess;

import ru.yandex.inside.yt.kosher.ytree.YTreeNode;

/**
 * Базовый класс FlatRow для различных ленивых трансформаций
 */
public abstract class FlatRowView extends AbstractList<YTreeNode> implements RandomAccess {
    protected FlatRowView() {
        // nothing
    }

    protected final void validateViewIndexes(int fromIndex, int toIndex) {
        if (fromIndex < 0 || fromIndex > size() || toIndex < fromIndex || toIndex > size()) {
            throw new IndexOutOfBoundsException("view(" + fromIndex + ", " + toIndex + ") when size = " + size());
        }
    }

    public FlatRowView view(int fromIndex, int toIndex) {
        validateViewIndexes(fromIndex, toIndex);
        return new SubView(this, fromIndex, toIndex - fromIndex);
    }

    @Override
    public String toString() {
        return "FlatRowView{columns=" + super.toString() + "}";
    }

    /**
     * Дефолтная реализация операции view
     */
    private static final class SubView extends FlatRowView {
        private final FlatRowView parent;
        private final int offset;
        private final int size;

        private SubView(FlatRowView parent, int offset, int size) {
            this.parent = parent;
            this.offset = offset;
            this.size = size;
        }

        @Override
        public FlatRowView view(int fromIndex, int toIndex) {
            validateViewIndexes(fromIndex, toIndex);
            return new SubView(parent, offset + fromIndex, toIndex - fromIndex);
        }

        @Override
        public YTreeNode get(int index) {
            if (index < 0 || index >= size) {
                throw new IndexOutOfBoundsException("get(" + index + ") when size = " + size);
            }
            return parent.get(offset + index);
        }

        @Override
        public int size() {
            return size;
        }
    }
}
