package ru.yandex.direct.mysql.ytsync.common.tables;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import ru.yandex.direct.mysql.ytsync.common.compatibility.YtSupport;

/**
 * Интерфейс для контейнеров с отложенными операциями записи на yt
 */
public interface TableWriteOperations {
    /**
     * Применяет накопленные операции в рамках транзакции tx
     */
    default CompletableFuture<Void> apply(YtSupport.Transaction tx) {
        return prepare(tx).thenComposeAsync(snapshots -> TableWriteSnapshot.applyAll(tx, snapshots), tx.executor());
    }

    /**
     * Подготавливает накопленные операции к записи и возвращает их
     * <p>
     * Сама запись данных при этом не производится
     */
    CompletableFuture<List<TableWriteSnapshot>> prepare(YtSupport.Transaction tx);
}
