package ru.yandex.direct.mysql.ytsync.common.tables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;

import ru.yandex.direct.mysql.ytsync.common.compatibility.YtSupport;
import ru.yandex.direct.mysql.ytsync.common.row.FlatRowView;
import ru.yandex.direct.mysql.ytsync.common.util.YtSyncCommonUtil;
import ru.yandex.yt.ytclient.tables.TableSchema;

/**
 * Моделирует иммутабельную операцию обновления данных на yt
 */
public class TableWriteSnapshot {
    private final String path;
    private final TableSchema writeSchema;
    private final List<? extends FlatRowView> insertedRows;
    private final List<? extends FlatRowView> updatedRows;
    private final List<? extends FlatRowView> deletedKeys;

    public TableWriteSnapshot(String path, TableSchema writeSchema,
                              List<? extends FlatRowView> insertedRows,
                              List<? extends FlatRowView> updatedRows,
                              List<? extends FlatRowView> deletedKeys) {
        this.path = path;
        this.writeSchema = writeSchema;
        this.insertedRows = insertedRows;
        this.updatedRows = updatedRows;
        this.deletedKeys = deletedKeys;
    }

    public String getPath() {
        return path;
    }

    public TableSchema getWriteSchema() {
        return writeSchema;
    }

    public List<? extends FlatRowView> getInsertedRows() {
        return Collections.unmodifiableList(insertedRows);
    }

    public List<? extends FlatRowView> getUpdatedRows() {
        return Collections.unmodifiableList(updatedRows);
    }

    public List<? extends FlatRowView> getDeletedKeys() {
        return Collections.unmodifiableList(deletedKeys);
    }

    public int size() {
        return insertedRows.size() + updatedRows.size() + deletedKeys.size();
    }

    public CompletableFuture<Void> apply(YtSupport.Transaction tx) {
        return tx.modifyRows(path, writeSchema, insertedRows, updatedRows, deletedKeys);
    }

    public static CompletableFuture<Void> applyAll(YtSupport.Transaction tx, List<TableWriteSnapshot> snapshots) {
        if (snapshots.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        List<CompletableFuture<Void>> futures = new ArrayList<>();
        for (TableWriteSnapshot snapshot : snapshots) {
            futures.add(snapshot.apply(tx));
        }
        return YtSyncCommonUtil.allFutures(futures);
    }
}
