package ru.yandex.direct.mysql.ytsync.common.util;

import java.sql.Connection;
import java.sql.SQLException;

/**
 * Класс позволяет получать готовые соединения для импорта данных из mysql
 * либо настройки для подключения от имени слейвов (при чтении бинлогов напрямую из mysql)
 * и подписываться на обновления настроек для подключения.
 */
public interface MySqlConnectionProvider {
    /**
     * Этот метод используется для первоначального (полного) импорта.
     */
    Connection createConnectionForImport(String dbName) throws SQLException;

    /**
     * Этот метод используется для инкрементального импорта.
     */
    MySqlConnectionSettings getSettingsForSync(String dbName) throws SQLException;

    /**
     * Подписаться на событие изменения настроек подключения к mysql.
     */
    void addListener(MySqlSettingsChangedListener settingsChangedListener);

    /**
     * Отписаться от события.
     */
    void removeListener(MySqlSettingsChangedListener settingsChangedListener);
}
