package ru.yandex.direct.mysql.ytsync.synchronizator.streamer.mysql;

public enum ChecksumMethod {
    CRC,
    TO_STRING,
    NULLS_CNT;

    public static ChecksumMethod fromSource(String value) {
        switch (value) {
            case "Crc":
                return ChecksumMethod.CRC;
            case "ToString":
                return TO_STRING;
            case "NullsCnt":
                return ChecksumMethod.NULLS_CNT;
            default:
                throw new IllegalStateException("Unknown value: " + value);
        }
    }

    public String toSource() {
        switch (this) {
            case CRC:
                return "Crc";
            case TO_STRING:
                return "ToString";
            case NULLS_CNT:
                return "NullsCnt";
            default:
                throw new IllegalStateException("Unknown value: " + this);
        }
    }
}
