package ru.yandex.direct.mysql.ytsync.synchronizator.streamer.mysql;

import java.sql.Timestamp;

public class ChecksumRecord {
    public static final String YT_CHECKSUM = "yt_checksum";

    private final String table;
    private final Integer iteration;
    private final Integer chunk;
    private final Integer parentChunk;
    private final String boundaries;
    private final ChecksumMethod method;
    private final String crc;
    private final Integer crcCnt;
    private final String str;
    private final String nullsCnt;
    private final String columnsUsed;
    private ChecksumStatus status;
    private final Timestamp ts;

    public ChecksumRecord(String table, Integer iteration, Integer chunk, Integer parentChunk, String boundaries,
                          ChecksumMethod method, String crc, Integer crcCnt, String str, String nullsCnt,
                          String columnsUsed, ChecksumStatus status, Timestamp ts) {
        this.table = table;
        this.iteration = iteration;
        this.chunk = chunk;
        this.parentChunk = parentChunk;
        this.boundaries = boundaries;
        this.method = method;
        this.crc = crc;
        this.crcCnt = crcCnt;
        this.str = str;
        this.nullsCnt = nullsCnt;
        this.columnsUsed = columnsUsed;
        this.status = status;
        this.ts = ts;
    }

    public String getTable() {
        return table;
    }

    public Integer getIteration() {
        return iteration;
    }

    public Integer getChunk() {
        return chunk;
    }

    public Integer getParentChunk() {
        return parentChunk;
    }

    public String getBoundaries() {
        return boundaries;
    }

    public ChecksumMethod getMethod() {
        return method;
    }

    public String getCrc() {
        return crc;
    }

    public Integer getCrcCnt() {
        return crcCnt;
    }

    public String getStr() {
        return str;
    }

    public String getNullsCnt() {
        return nullsCnt;
    }

    public String getColumnsUsed() {
        return columnsUsed;
    }

    public ChecksumStatus getStatus() {
        return status;
    }

    public Timestamp getTs() {
        return ts;
    }

    @Override
    public String toString() {
        return "ChecksumRecord{" +
                "table='" + table + '\'' +
                ", iteration=" + iteration +
                ", chunk=" + chunk +
                ", parentChunk=" + parentChunk +
                ", boundaries='" + boundaries + '\'' +
                ", method=" + method +
                ", crc='" + crc + '\'' +
                ", crcCnt=" + crcCnt +
                ", str='" + str + '\'' +
                ", nullsCnt='" + nullsCnt + '\'' +
                ", columnsUsed='" + columnsUsed + '\'' +
                ", status=" + status +
                ", ts=" + ts +
                '}';
    }
}
