package ru.yandex.direct.mysql.ytsync.synchronizator.streamer.mysql;

public enum ChecksumStatus {
    STARTED,
    CANCELLED,
    FINISHED,
    FAILED;

    public static ChecksumStatus fromSource(String value) {
        switch (value) {
            case "Started":
                return STARTED;
            case "Cancelled":
                return CANCELLED;
            case "Finished":
                return FINISHED;
            case "Failed":
                return FAILED;
            default:
                throw new IllegalStateException("Unknown value: " + value);
        }
    }

    public String toSource() {
        switch (this) {
            case STARTED:
                return "Started";
            case CANCELLED:
                return "Cancelled";
            case FINISHED:
                return "Finished";
            case FAILED:
                return "Failed";
            default:
                throw new IllegalStateException("Unknown value: " + this);
        }
    }
}
