package ru.yandex.direct.mysql.ytsync.synchronizator.streamer.mysql;

import java.util.List;
import java.util.function.Consumer;

import ru.yandex.direct.mysql.MySQLBinlogState;
import ru.yandex.direct.mysql.ytsync.synchronizator.operation.YtPendingTransaction;
import ru.yandex.inside.yt.kosher.cypress.YPath;

public interface MysqlTransactionAggregator {
    boolean isReady();

    boolean isClosed();

    void lockAndRun(Consumer<AggregatorLock> runnable);

    MySQLBinlogState getCurrentAggregatorState();

    MySQLBinlogState getCurrentAggregatorState(boolean clearCacheBeforeLookup);

    /**
     * Подождать, пока всё, что было добавлено в агрегатор, будет записано в yt.
     */
    void awaitPendingIsFlushed() throws InterruptedException;

    void refreshSchemaOnPaths(List<YPath> pathsToReload);

    void refreshAllSchemas();

    void addTransaction(long timestamp, YtPendingTransaction tx, MySQLBinlogState state,
                        Runnable consistencyViolationHandler) throws InterruptedException;

    void close();

    boolean isFlusherThreadAlive();

    /**
     * Выполняет сверку контрольной суммы чанка, сгенерированного в mysql, с данными в YT
     * Результат записывается в таблицу yt_checksum в YT
     *
     * @param checksum Контрольная сумма, посчитанная на стороне mysql
     * @param timestamp ts события-insert'a
     * @throws InterruptedException Если тред был поинтеррапчен
     * @return true если чексумма была обработана, false если была проигнорирована
     */
    boolean verifyChecksum(ChecksumRecord checksum, long timestamp) throws InterruptedException;
}
