package ru.yandex.direct.mysql.ytsync.synchronizator.tableprocessors;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.function.Function;

import ru.yandex.direct.mysql.MySQLColumnData;
import ru.yandex.direct.mysql.MySQLColumnType;
import ru.yandex.misc.lang.number.UnsignedLong;

public interface MySqlColumnValueExtractor<T> extends Function<MySQLColumnData, T> {
    static MySqlColumnValueExtractor<Long> longExtractor() {
        return d -> d.getRawValue() != null ?
                MySQLColumnType.getCached(d.getSchema().getColumnType()).extractLong(d.getRawValue()) :
                null;
    }

    static MySqlColumnValueExtractor<String> stringExtractor() {
        return d -> d.getRawValue() != null ?
                MySQLColumnType.getCached(d.getSchema().getColumnType()).extractString(d.getRawValue()) :
                null;
    }

    static MySqlColumnValueExtractor<BigDecimal> doubleExtractor() {
        return d -> {
            String v = d.getRawValue() != null ?
                    MySQLColumnType.getCached(d.getSchema().getColumnType()).extractString(d.getRawValue()) :
                    null;

            if (v != null) {
                return new BigDecimal(v);
            }
            return null;
        };
    }

    static MySqlColumnValueExtractor<LocalDate> localDateExtractor() {
        return d -> d.getRawValue() != null
                ? MySQLColumnType.getCached(d.getSchema().getColumnType()).extractLocalDate(d.getRawValue())
                : null;
    }

    static MySqlColumnValueExtractor<LocalDateTime> localDateTimeExtractor() {
        return d -> d.getRawValue() != null
                ? MySQLColumnType.getCached(d.getSchema().getColumnType()).extractLocalDateTime(d.getRawValue())
                : null;
    }

    static MySqlColumnValueExtractor<UnsignedLong> unsignedLongExtractor() {
        return d -> {
            String v = d.getRawValue() != null ?
                    MySQLColumnType.getCached(d.getSchema().getColumnType()).extractString(d.getRawValue()) :
                    null;
            if (v != null) {
                return UnsignedLong.valueOf(Long.parseUnsignedLong(v, 10));
            }
            return null;
        };
    }
}
