package ru.yandex.direct.mysql.ytsync.synchronizator.tableprocessors;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import one.util.streamex.EntryStream;

import ru.yandex.direct.mysql.MySQLColumnData;
import ru.yandex.direct.mysql.MySQLSimpleRow;
import ru.yandex.direct.mysql.ytsync.common.row.FlatRow;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;
import ru.yandex.yt.ytclient.tables.TableSchema;

public class SyncFlatRowCreator implements SyncFlatRowCreatorBase {
    private final TableSchema schema;
    private final Map<String, Map<String, List<SyncFlatRowFieldProcessor<?>>>> tableFieldObj;
    private final List<SyncFlatRowFieldProcessor<?>> additionalFields;
    private final List<SyncFlatRowFieldProcessor<?>> optionalAdditionalFields;

    public SyncFlatRowCreator(TableSchema schema, String mainTable, Collection<String> mainTableKeys,
                              Map<String, Map<String, List<SyncFlatRowFieldProcessor<?>>>> tableFieldObj,
                              List<SyncFlatRowFieldProcessor<?>> additionalFields,
                              List<SyncFlatRowFieldProcessor<?>> optionalAdditionalFields) {
        this.schema = schema.toWrite();
        this.tableFieldObj = tableFieldObj;
        EntryStream.of(tableFieldObj)
                .filterKeys(k -> !mainTable.equals(k))
                .forKeyValue((k, v) -> addKeys(v, tableFieldObj.get(mainTable), mainTableKeys));

        this.additionalFields = additionalFields;
        this.optionalAdditionalFields = optionalAdditionalFields;
    }

    private void addKeys(Map<String, List<SyncFlatRowFieldProcessor<?>>> target,
                         Map<String, List<SyncFlatRowFieldProcessor<?>>> source, Collection<String> mainTableKeys) {
        // source ключами имеет названия колонок из исходной таблицы, а в значениях хранит замапленные названия
        // колонок в YT; mainTableKeys же содержит названия в YT. Поэтому для правильного добавления колонок ключей в
        // target нужно дополнительно учитывать различие в названиях колонок между YT и SQL.
        var schemaIdsToSourceIds = new HashMap<String, String>();
        source.forEach((sourceKey, processors) ->
                processors.forEach(p -> schemaIdsToSourceIds.put(p.getName(), sourceKey)));
        for (var mainTableKey : mainTableKeys) {
            if (source.containsKey(mainTableKey)) {
                target.put(mainTableKey, source.get(mainTableKey));
            } else if (schemaIdsToSourceIds.containsKey(mainTableKey)) {
                // На момент написания данный кейс нужен и срабатыает только для маппинга BIDS_BASE.BID_ID == BIDS.ID
                target.put(mainTableKey, source.get(schemaIdsToSourceIds.get(mainTableKey)));
            }
        }
    }

    @Override
    public FlatRow createFrom(String dbName, String tableName, MySQLSimpleRow mySqlRow, boolean needAdditional) {
        FlatRow row = new FlatRow(schema.getColumnsCount());

        var fieldToProcessors = tableFieldObj.get(tableName);

        if (fieldToProcessors != null) {
            for (MySQLColumnData mySQLColumnData : mySqlRow) {
                String fieldName = mySQLColumnData.getSchema().getName();

                List<SyncFlatRowFieldProcessor<?>> processors = fieldToProcessors.get(fieldName);
                if (processors != null) {
                    for (SyncFlatRowFieldProcessor<?> field : processors) {
                        YTreeNode node = field.createNode(dbName, mySQLColumnData);
                        row.set(schema.findColumn(field.getName()), node);
                    }
                }
            }
        }

        for (SyncFlatRowFieldProcessor<?> field : additionalFields) {
            YTreeNode node = field.createNode(dbName, null);
            row.set(schema.findColumn(field.getName()), node);
        }

        if (needAdditional) {
            for (SyncFlatRowFieldProcessor<?> field : optionalAdditionalFields) {
                YTreeNode node = field.createNode(dbName, null);
                row.set(schema.findColumn(field.getName()), node);
            }
        }

        return row;
    }
}
