package ru.yandex.direct.mysql.ytsync.synchronizator.tableprocessors;

import java.util.Map;

import ru.yandex.direct.mysql.MySQLSimpleRow;
import ru.yandex.direct.mysql.ytsync.common.row.FlatRow;

public class SyncFlatRowCreatorPack implements SyncFlatRowCreatorBase {
    private final Map<String, SyncFlatRowCreatorBase> tableToCreator;

    public SyncFlatRowCreatorPack(Map<String, SyncFlatRowCreatorBase> tableToCreator) {
        this.tableToCreator = tableToCreator;
    }

    /**
     * Возвращает данные для запроса в YT.
     * Для main таблиц использует конкретную имплементацию SyncFlatRowCreator-а,
     * для сджойненных таблиц используется какая-то.
     * <p>
     * Пример логики для таблицы bids : состоит из отдельных конфигураций для main таблиц bids, bids_base и bids_arc
     * с общими для всех конфигураций колонками таблицы aggr_statuses_keywords. Если изменения произошли в одной из
     * main таблиц, то выбор конфигурации важен; если же изменения произошли в aggr_statuses_keywords, то подойдет
     * любая из представленных конфигураций, поскольку они реализуются/должны реализоваться одинаково.
     *
     * @param dbName         - бд
     * @param tableName      - SQL-таблица, в которой произошли изменения
     * @param mySqlRow       - строка с изменениями
     * @param needAdditional - есть ли опциональные дополнительные поля
     * @return массив данных для создания запрос по изменению YT-таблицы
     */
    @Override
    public FlatRow createFrom(String dbName, String tableName, MySQLSimpleRow mySqlRow, boolean needAdditional) {
        var syncFlatRowCreator = tableToCreator.get(tableName);
        if (syncFlatRowCreator == null) {
            syncFlatRowCreator = tableToCreator.values().iterator().next();
        }
        return syncFlatRowCreator.createFrom(dbName, tableName, mySqlRow, needAdditional);
    }
}
