package ru.yandex.direct.mysql.ytsync.synchronizator.tableprocessors;

import java.util.Set;

import ru.yandex.direct.mysql.BinlogEventData;
import ru.yandex.direct.mysql.ytsync.synchronizator.tables.Table;
import ru.yandex.direct.mysql.ytsync.synchronizator.tables.TableWriteSink;

public interface TableProcessor {
    /**
     * Сбрасывает накопленные данные в нижестоящие sink'и
     * <p>
     * Любые локально закешированные данные также должны очищаться
     */
    void flush();

    Table getMainTable();

    /**
     * Возвращает TableWriteSink в которые процессор пишет свои сырые данные
     */
    Set<TableWriteSink> getSinks();

    /**
     * Вызывается для обработки операции DELETE
     *
     * @return оценка кол-ва добавленных элементарных операций записи
     */
    int handleDelete(BinlogEventData.Delete deleted, String dbName);

    /**
     * Вызывается для обработки операции INSERT
     *
     * @return оценка кол-ва добавленных элементарных операций записи
     */
    int handleInsert(BinlogEventData.Insert inserted, String dbName);

    /**
     * Вызывается для обработки операции UPDATE
     *
     * @return оценка кол-ва добавленных элементарных операций записи
     */
    int handleUpdate(BinlogEventData.Update updated, String dbName);
}
