package ru.yandex.direct.mysql.ytsync.synchronizator.tables;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import ru.yandex.direct.mysql.ytsync.common.compatibility.YtSupport;
import ru.yandex.direct.mysql.ytsync.common.row.FlatRow;
import ru.yandex.direct.mysql.ytsync.common.row.FlatRowView;
import ru.yandex.yt.ytclient.tables.TableSchema;

/**
 * Интерфейс для работы с одной целевой таблицей на yt
 */
public interface Table extends TableWriteSink, TableReadSource {
    /**
     * Возвращает полную схему таблицы
     */
    TableSchema getSchema();

    /**
     * Монтирует или анфризит таблицу, чтобы добиться состояния "mounted"
     */
    void makeTableMounted();

    /**
     * В рамках транзакции tx читает строки с ключами keys и возвращает результаты во write схеме
     */
    default CompletableFuture<List<FlatRow>> lookupRows(YtSupport.Transaction tx, List<? extends FlatRowView> keys) {
        return lookupRows(tx, keys, getWriteSchema());
    }
}
