package ru.yandex.direct.mysql.ytsync.synchronizator.tables;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import ru.yandex.direct.mysql.ytsync.common.compatibility.YtSupport;
import ru.yandex.direct.mysql.ytsync.common.row.FlatRow;
import ru.yandex.direct.mysql.ytsync.common.tables.TableWriteSnapshot;
import ru.yandex.direct.mysql.ytsync.common.util.YtSyncCommonUtil;
import ru.yandex.yt.ytclient.tables.TableSchema;

/**
 * Базовая реализация для таблиц на yt
 */
public class TableBase implements Table {
    protected final YtSupport yt;
    private final String path;
    private final TableSchema schema;
    private final TableSchema writeSchema;
    private final TableSchema lookupSchema;
    private final TableWriteBuffer writeBuffer;

    public TableBase(
            YtSupport yt,
            String path,
            TableSchema schema) {
        this.yt = yt;
        this.path = path;
        this.schema = schema;
        this.writeSchema = schema.toWrite();
        this.lookupSchema = writeSchema.toLookup();
        this.writeBuffer = new TableWriteBuffer(path, schema);
    }

    @Override
    public String getPath() {
        return path;
    }

    @Override
    public TableSchema getSchema() {
        return schema;
    }

    @Override
    public TableSchema getWriteSchema() {
        return writeSchema;
    }

    @Override
    public TableSchema getLookupSchema() {
        return lookupSchema;
    }

    @Override
    public void makeTableMounted() {
        YtSyncCommonUtil.makeTableMounted(yt, path, true);
    }

    @Override
    public void clear() {
        writeBuffer.clear();
    }

    @Override
    public int addDelete(FlatRow row) {
        return writeBuffer.addDelete(row);
    }

    @Override
    public int addInsert(FlatRow row) {
        return writeBuffer.addInsert(row);
    }

    @Override
    public int addUpdate(FlatRow before, FlatRow after) {
        return writeBuffer.addUpdate(before, after);
    }

    @Override
    public CompletableFuture<List<TableWriteSnapshot>> prepare(YtSupport.Transaction tx) {
        return writeBuffer.prepare(tx);
    }

    public boolean isConsistencyViolationFound() {
        return writeBuffer.isConsistencyViolationFound();
    }
}
