package ru.yandex.direct.mysql.ytsync.synchronizator.tables;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import ru.yandex.direct.mysql.ytsync.common.compatibility.YtSupport;
import ru.yandex.direct.mysql.ytsync.common.row.FlatRow;
import ru.yandex.direct.mysql.ytsync.common.row.FlatRowView;
import ru.yandex.yt.ytclient.tables.TableSchema;

/**
 * Интерфейс, позволяющий читать данные из таблицы на yt
 */
public interface TableReadSource {
    /**
     * Возвращает путь к таблице
     */
    String getPath();

    /**
     * Возвращает схему, которая используется для чтения данных (ключ)
     */
    TableSchema getLookupSchema();

    /**
     * В рамках транзакции tx читает строки с ключами keys и возвращает результаты в схеме resultSchema
     */
    default CompletableFuture<List<FlatRow>> lookupRows(YtSupport.Transaction tx, List<? extends FlatRowView> keys,
                                                        TableSchema resultSchema) {
        return tx.lookupRows(getPath(), getLookupSchema(), keys, resultSchema);
    }
}
