package ru.yandex.direct.mysql.ytsync.synchronizator.tables;

import ru.yandex.direct.mysql.ytsync.common.row.FlatRow;
import ru.yandex.direct.mysql.ytsync.common.tables.TableWriteOperations;
import ru.yandex.yt.ytclient.tables.TableSchema;

/**
 * Интерфейс для классов, которые так или иначе пишут данные в таблицу на yt
 */
public interface TableWriteSink extends TableWriteOperations {
    /**
     * Возвращает путь к таблице
     */
    String getPath();

    /**
     * Возвращает схему, которая используется для записи данных в таблицу
     */
    TableSchema getWriteSchema();

    /**
     * Очищает накопленные операции
     */
    void clear();

    /**
     * Добавляет DELETE операцию
     *
     * @param row ключ или целая строка для удаления
     * @return изменение в кол-ве будущих операций записи
     */
    int addDelete(FlatRow row);

    /**
     * Добавляет INSERT операцию
     *
     * @param row целая строка для вставки
     * @return изменение в кол-ве будущих операций записи
     */
    int addInsert(FlatRow row);

    /**
     * Добавляет UPDATE операцию
     *
     * @param row строка с обновлениями
     * @return изменение в кол-ве будущих операций записи
     */
    default int addUpdate(FlatRow row) {
        return addUpdate(null, row);
    }

    /**
     * Добавляет UPDATE операцию
     *
     * @param before ключ или строка для обновления (может быть null)
     * @param after  обновления колонок
     * @return изменение в кол-ве будущих операций записи
     */
    int addUpdate(FlatRow before, FlatRow after);

    boolean isConsistencyViolationFound();
}
