package ru.yandex.direct.mysql.ytsync.synchronizator.util;

import java.time.LocalTime;

import com.google.common.base.Preconditions;

public class SnapshotConfig {
    // Запуск разрешён (вообще). Если false, то снепшоты сниматься не будут
    private final boolean enabled;
    // Начало интервала времени, в течение которого будут предприниматься попытки снять снепшот
    private final LocalTime intervalFrom;
    // Окончание этого интервала, должно быть строго больше чем intervalFrom
    private final LocalTime intervalTo;
    // Флаг, разрешающий снятие формирование снепшота на не-stable инстансах
    // (то есть тех, на которые не указывает current)
    private final boolean enabledOnPrestable;

    public SnapshotConfig(boolean enabled, LocalTime intervalFrom, LocalTime intervalTo, boolean enabledOnPrestable) {
        Preconditions.checkState(intervalFrom.isBefore(intervalTo));
        //
        this.enabled = enabled;
        this.intervalFrom = intervalFrom;
        this.intervalTo = intervalTo;
        this.enabledOnPrestable = enabledOnPrestable;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public LocalTime getIntervalFrom() {
        return intervalFrom;
    }

    public LocalTime getIntervalTo() {
        return intervalTo;
    }

    public boolean isEnabledOnPrestable() {
        return enabledOnPrestable;
    }

    @Override
    public String toString() {
        return "SnapshotConfig{" +
                "enabled=" + enabled +
                ", intervalFrom=" + intervalFrom +
                ", intervalTo=" + intervalTo +
                ", enabledOnPrestable=" + enabledOnPrestable +
                '}';
    }
}
