package ru.yandex.direct.mysql.ytsync.synchronizator.util;

import java.util.List;
import java.util.Set;

import ru.yandex.direct.ytwrapper.model.YtCluster;

public interface SyncConfig {
    YtCluster cluster();

    boolean importAllTables();

    Set<String> getExcludeTableNames();

    int mysqlServerId();

    String streamStopAfterSet(String dbName);

    List<String> getDbNames();

    String syncLocksPrefix();

    boolean useRpcTransactions();

    int maxPendingOperations();

    int flushEveryMillis();

    int globalProgressTimeoutSeconds();

    String stableLinkPath();

    String rootPath();

    SnapshotConfig snapshotConfig();

    boolean verifyChecksums();

    boolean processReshardingEvents();
}
