package ru.yandex.direct.libs.oauth.client.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class ApplicationInfo {
    @JsonProperty
    private String id;
    @JsonProperty
    private String name;
    @JsonProperty
    private String description;
    @JsonProperty
    private String homepage;
    @JsonProperty
    private String callback;

    @JsonProperty
    private List<String> scope;
    @JsonProperty
    private List<String> localizedScope;

    public String id() {
        return id;
    }

    public String name() {
        return name;
    }

    public String description() {
        return description;
    }

    public String homepage() {
        return homepage;
    }

    public String callback() {
        return callback;
    }

    public List<String> scope() {
        return scope;
    }

    public List<String> localizedScope() {
        return localizedScope;
    }

    @Override
    public String toString() {
        return "ApplicationInfo{" +
                "id='" + id + '\'' +
                ", name='" + name + '\'' +
                ", description='" + description + '\'' +
                ", homepage='" + homepage + '\'' +
                ", callback='" + callback + '\'' +
                ", scope=" + scope +
                ", localizedScope=" + localizedScope +
                '}';
    }
}
