package ru.yandex.direct.operation;

/**
 * Применимость операции в зависимости от результатов валидации
 */
public enum Applicability {

    /**
     * Можно применять к любому подмножеству валидных элементов при наличии невалидных.
     * <p>
     * Если после выполнения {@link Operation#prepare()} валидным оказался хотябы один элемент,
     * то операция применима, то есть можно вызывать {@link Operation#apply()}
     */
    PARTIAL,

    /**
     * Можно применять только ко всем элементам или ни к одному.
     * <p>
     * Если при выполнении {@link Operation#prepare()} обнаружился хотя бы один
     * невалидный элемент, то операция неприменима (метод {@link Operation#prepare()})
     * возвращает непустой {@link java.util.Optional} с неуспешным результатом выполнения.
     */
    FULL;

    public static boolean isFull(Applicability applicability) {
        return applicability == FULL;
    }

    public static boolean isPartial(Applicability applicability) {
        return applicability == PARTIAL;
    }
}
