package ru.yandex.direct.operation;

import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.utils.converter.Converter;

@ParametersAreNonnullByDefault
public class ConvertResultOperation<R1, R2> implements Operation<R2> {
    private final Operation<R1> operation;
    private final Converter<MassResult<R1>, MassResult<R2>> resultConverter;

    public ConvertResultOperation(Operation<R1> operation,
                                  Converter<MassResult<R1>, MassResult<R2>> resultConverter) {
        this.operation = operation;
        this.resultConverter = resultConverter;
    }

    @Override
    public Optional<MassResult<R2>> prepare() {
        return operation.prepare().map(resultConverter::convert);
    }

    @Override
    public MassResult<R2> apply() {
        return resultConverter.convert(operation.apply());
    }

    @Override
    public MassResult<R2> cancel() {
        return resultConverter.convert(operation.cancel());
    }

    @Override
    public Optional<MassResult<R2>> getResult() {
        return operation.getResult().map(resultConverter::convert);
    }
}
