package ru.yandex.direct.operation;

import java.util.Optional;
import java.util.Set;

import ru.yandex.direct.result.MassResult;

import static com.google.common.base.Preconditions.checkArgument;
import static java.util.Collections.emptySet;

/**
 * Пустая операция. Подразумевается, что операция применяется на пустой список, он валиден. После выполнения операции
 * будет успешный результат, состоящий из пустого списка.
 *
 * @param <R> тип параметра возвращаемого объекта {@link MassResult}
 */
public class EmptyOperation<R> implements PartiallyApplicableOperation<R> {
    private MassResult<R> result;

    @Override
    public Optional<MassResult<R>> prepare() {
        return Optional.empty();
    }

    @Override
    public MassResult<R> apply() {
        result = MassResult.emptyMassAction();
        return result;
    }

    @Override
    public MassResult<R> cancel() {
        result = MassResult.emptyMassAction();
        return result;
    }

    @Override
    public Optional<MassResult<R>> getResult() {
        return Optional.ofNullable(result);
    }

    @Override
    public Set<Integer> getValidElementIndexes() {
        return emptySet();
    }

    @Override
    public MassResult<R> apply(Set<Integer> elementIndexesToApply) {
        checkArgument(elementIndexesToApply.equals(emptySet()));
        result = MassResult.emptyMassAction();
        return result;
    }
}
