package ru.yandex.direct.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkState;
import static java.util.function.Function.identity;

public class OperationsUtils {

    public static <T, R> Map<Integer, R> applyForMapValues(Map<Integer, T> inputMap,
                                                           Function<List<T>, List<R>> function) {
        return applyForMapValues(inputMap, identity(), function);
    }

    public static <T, T1, R> Map<Integer, R> applyForMapValues(Map<Integer, T> inputMap,
                                                               Function<T, T1> converter,
                                                               Function<List<T1>, List<R>> function) {
        List<T1> inputList = new ArrayList<>();
        Map<Integer, Integer> localToSourceIndexMap = fillListFromMap(inputList, inputMap, converter);
        List<R> outputList = function.apply(inputList);
        checkState(outputList.size() == inputList.size(),
                "function must return a list of results with the same size as input list");
        return recoverMapFromList(outputList, localToSourceIndexMap);
    }

    /**
     * Перемещает значения из map в list. Возвращает маппинг новых индексов на старые
     */
    public static <T> Map<Integer, Integer> fillListFromMap(List<T> list, Map<Integer, T> map) {
        return fillListFromMap(list, map, identity());
    }

    /**
     * Перемещает значения из map в list, преобразовывая их с помощью converter.
     * Возвращает маппинг новых индексов на старые
     */
    public static <T, R> Map<Integer, Integer> fillListFromMap(List<R> list, Map<Integer, T> map,
                                                               Function<T, R> converter) {
        checkArgument(list.isEmpty(), "empty list expected");
        Map<Integer, Integer> localToSourceMap = new HashMap<>();
        int localIndex = 0;
        for (Map.Entry<Integer, T> entry : map.entrySet()) {
            list.add(converter.apply(entry.getValue()));
            localToSourceMap.put(localIndex++, entry.getKey());
        }
        return localToSourceMap;
    }

    /**
     * Переносит элементы из list<T> в map<Integer, T>, используя маппинг индексов листа на будущие ключи в map.
     */
    public static <T> Map<Integer, T> recoverMapFromList(List<T> list, Map<Integer, Integer> localToSourceIndexMap) {
        Map<Integer, T> map = new HashMap<>();
        for (int i = 0; i < list.size(); i++) {
            map.put(localToSourceIndexMap.get(i), list.get(i));
        }
        return map;
    }
}
