package ru.yandex.direct.operation;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

/**
 * Расширенный интерфейс операции, наделенный знанием о типе модели.
 */
@ParametersAreNonnullByDefault
public interface PartiallyApplicableModelOperation<M extends ModelWithId, R> extends PartiallyApplicableOperation<R> {
    /**
     * Получение результата валидации элементов.
     * <p>
     * Метод можно вызвать только после вызова метода {@link #prepare()}.
     * Если есть ошибка валидации уровня операции, должно возвращаться пустое множество
     *
     * @return результат валидации
     */
    ValidationResult<List<M>, Defect> getValidationResult();
}
