package ru.yandex.direct.operation;

import java.util.Set;

import ru.yandex.direct.result.MassResult;


/**
 * Интерфейс операции над списком элементов с возможностью частичного применения. Операция применяется только
 * к тем элементам индексы которых передаются в {@link #apply(Set)}. Такое поведение позволяет совместно
 * валидировать несколько операций и применять операцию только к тем элементам, которые валидны во всех
 * операциях.
 */
public interface PartiallyApplicableOperation<R> extends Operation<R> {
    /**
     * Получение индексов тех элементов, которые успешно провалидированы и готовы к применению операции.
     * <p>
     * Метод можно вызвать только после вызова метода {@link #prepare()}.
     * Если есть ошибка валидации уровня операции, должно возвращаться пустое множество
     *
     * @return индексы валидных элементов
     */
    Set<Integer> getValidElementIndexes();

    /**
     * Выполнить операцию, для элементов прошедших фильтр.
     * <p>
     * Операция должна выполниться только для тех элементов, индекс которых есть в {@code elementIndexesToApply}.
     * В результате, элементы без ошибок, не попавшие в {@code elementIndexesToApply}, помечаются отменёнными.
     * Если в elementIndexesToApply есть индекс невалидного элемента, должно быть сгенерировано исключение.
     *
     * @param elementIndexesToApply фильтр элементов по индексу
     * @return результат выполнения операции
     */
    MassResult<R> apply(Set<Integer> elementIndexesToApply);
}
