package ru.yandex.direct.operation.add;

import java.util.List;
import java.util.Map;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.operation.OperationsUtils;

/**
 * Упрощение AbstractAddOperation за счет метода execute(List<M>).
 * Использовать, когда в операции execute не имеют значения индексы моделей в исходном массиве.
 *
 * @param <M> тип модели
 */
public abstract class SimpleAbstractAddOperation<M extends ModelWithId, R> extends AbstractAddOperation<M, R> {
    public SimpleAbstractAddOperation(Applicability applicability, List<M> models) {
        super(applicability, models);
    }

    /**
     * Простая реализация метода создания валидных объектов в базе данных.
     * Размер входного map должен быть равен выходному и соответствовать ему по ключам
     *
     * @param validModelsMapToApply маппинг индексов в исходном массиве на модели, к которым должна примениться опреация
     * @return Map, соответствующий по размеру и ключам validModelsMapToApply, содержащий результаты для добавленных объектов
     */
    @Override
    protected final Map<Integer, R> execute(Map<Integer, M> validModelsMapToApply) {
        return OperationsUtils.applyForMapValues(validModelsMapToApply, this::execute);
    }

    /**
     * Абстрактный метод создания валидных объектов в базе данных, должен быть реализован в потомке.
     * <p>
     * Размер списка с результатами должен быть равен
     * размеру входного списка объектов и соответствовать ему по индексам.
     *
     * @param validModelsToApply список валидных объектов, к которым должна примениться опреация
     *                           (подмножество исходного списка объектов).
     * @return результаты для созданных объектов. Должен соответствовать входному списку по индексам.
     */
    protected abstract List<R> execute(List<M> validModelsToApply);
}
