package ru.yandex.direct.operation.creator;

import java.util.List;

import ru.yandex.direct.operation.Operation;

/**
 * Создаёт операцию по входящему списку элементов.
 * <p>
 * В интерфейсе {@link Operation} никак не фигурирует входящий список элементов,
 * операция создаётся уже с определённым списком, но в некоторых случаях полезно его знать
 * и использовать в принятии решения о том, как выполнять операцию.
 * <p>
 * Как может быть использован: например, для пустого входящего списка можно создавать операцию,
 * всегда возвращающую пустой результат ({@link OperationCreators#createEmptyOperationOnEmptyInput(OperationCreator)}),
 * или можно вообще не отправлять некоторые элементы в операцию, а сразу выдавать
 * для них результат ({@link IgnoreDuplicatesOperationCreator}.
 * <p>
 * Не стоит явно создавать реализацию {@code OperationCreator} для вновь создаваемых операций. Обычно нужен просто
 * метод, создающий операцию, в соотвествующем сервисе. Если потребуется, с помощью этого метода, можно будет
 * создать {@code OperationCreator} на месте, где это необходимо.
 * <p>
 *
 * @param <I>  тип элементов входящего списка
 * @param <OP> тип операции
 */
@FunctionalInterface
public interface OperationCreator<I, OP extends Operation> {
    OP create(List<I> operationInput);
}
