package ru.yandex.direct.operation.creator;

import java.util.List;
import java.util.function.Function;

import ru.yandex.direct.operation.EmptyOperation;
import ru.yandex.direct.operation.FunctionOperation;
import ru.yandex.direct.operation.Operation;
import ru.yandex.direct.operation.PartiallyApplicableOperation;
import ru.yandex.direct.result.MassResult;

public class OperationCreators {
    /**
     * Для пустого входного списка создаёт пустую операцию, которая безусловно выдаёт пустой {@link MassResult}
     *
     * @param operationCreator оборачиваемый создатель операций
     * @param <I>              тип элемента входного списка
     * @param <O>              тип элемента результата
     */
    public static <I, O> OperationCreator<I, Operation<O>> createEmptyOperationOnEmptyInput(
            OperationCreator<I, Operation<O>> operationCreator) {
        return operationInput -> operationInput.isEmpty() ?
                new EmptyOperation<>()
                : operationCreator.create(operationInput);
    }

    public static <I, O> OperationCreator<I, PartiallyApplicableOperation<O>> createEmptyPartiallyApplicableOperationOnEmptyInput(
            OperationCreator<I, PartiallyApplicableOperation<O>> operationCreator) {
        return operationInput -> operationInput.isEmpty() ?
                new EmptyOperation<>()
                : operationCreator.create(operationInput);
    }

    public static <I, O> OperationCreator<I, PartiallyApplicableOperation<O>> fromFunction(
            Function<List<I>, List<O>> function) {
        return operationInput -> new FunctionOperation<>(function, operationInput);
    }
}
