package ru.yandex.direct.operation.execution;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;

import com.google.common.collect.Sets;

import ru.yandex.direct.operation.PartiallyApplicableOperation;

public class PartiallyInParallelExecutionStrategy implements ExecutionStrategy<PartiallyApplicableOperation<?>> {
    @Override
    public boolean execute(Collection<? extends PartiallyApplicableOperation<?>> operations) {
        if (operations.isEmpty()) {
            return true;
        }
        operations.forEach(PartiallyApplicableOperation::prepare);
        Set<Integer> validIndexes = getValidElementIndexesOverAllOperations(operations);

        if (!validIndexes.isEmpty()) {
            operations.forEach(op -> op.apply(validIndexes));
            return true;
        } else {
            // отменяем операции кроме тех, в которых уже есть результат -- ошибка всей операции
            operations.stream()
                    .filter(op -> !op.getResult().isPresent())
                    .forEach(PartiallyApplicableOperation::cancel);
            return false;
        }
    }

    private Set<Integer> getValidElementIndexesOverAllOperations(
            Collection<? extends PartiallyApplicableOperation<?>> operations) {
        return operations.stream()
                .map(PartiallyApplicableOperation::getValidElementIndexes)
                .reduce(Sets::intersection)
                .orElse(Collections.emptySet());
    }

    @Override
    public void validate(Collection<? extends PartiallyApplicableOperation<?>> operations) {
        throw new UnsupportedOperationException();
    }
}
