package ru.yandex.direct.operation.tree;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

public final class ItemSubOperationExecutorBuilder {

    protected ItemSubOperationExecutorBuilder() {
    }

    public final <FP extends Model> FakeParentsStep<FP> withFakeParents(List<FP> fakeParents) {
        return new FakeParentsStep<>(fakeParents);
    }


    public static final class FakeParentsStep<FP extends Model> {
        private List<FP> fakeParents;

        private FakeParentsStep(List<FP> fakeParents) {
            this.fakeParents = fakeParents;
        }

        public <FC> FakeChildStep<FP, FC> withFakeChildProperty(
                ModelProperty<? super FP, FC> fakeChildProperty) {
            return new FakeChildStep<>(fakeParents, fakeChildProperty);
        }

        public <C> ChildStep<FP, C, C> withChildProperty(
                ModelProperty<? super FP, C> childProperty) {
            return new ChildStep<>(fakeParents, childProperty, Function.identity());
        }
    }


    public static final class FakeChildStep<FP extends Model, FC> {
        private List<FP> fakeParents;
        private ModelProperty<? super FP, FC> fakeChildProperty;

        private FakeChildStep(List<FP> fakeParents, ModelProperty<? super FP, FC> fakeChildProperty) {
            this.fakeParents = fakeParents;
            this.fakeChildProperty = fakeChildProperty;
        }

        public <C> ChildStep<FP, FC, C> withRealChildProperty(
                ModelProperty<? super FC, C> fakeChildToRealChildProperty) {
            return new ChildStep<>(fakeParents, fakeChildProperty, fakeChildToRealChildProperty::get);
        }
    }


    public static final class ChildStep<FP extends Model, FC, C> {
        private List<FP> fakeParents;
        private ModelProperty<? super FP, FC> fakeChildProperty;
        private Function<FC, C> fakeChildToRealChildFn;
        private Predicate<FP> fakeParentFilter = fp -> true;

        private ChildStep(List<FP> fakeParents, ModelProperty<? super FP, FC> fakeChildProperty,
                          Function<FC, C> fakeChildToRealChildFn) {
            this.fakeParents = fakeParents;
            this.fakeChildProperty = fakeChildProperty;
            this.fakeChildToRealChildFn = fakeChildToRealChildFn;
        }

        public ChildStep<FP, FC, C> withFiltering(Predicate<FP> fakeParentFilter) {
            this.fakeParentFilter = fakeParentFilter;
            return this;
        }

        public <P, SO extends SubOperation<C>> ItemSubOperationExecutor<P, C, SO> createSubOperationBy(
                SubOperationCreator<FC, SO> operationCreator) {
            return ItemSubOperationExecutor.create(fakeParents, fakeChildProperty,
                    fakeChildToRealChildFn, fakeParentFilter, operationCreator);
        }
    }
}
