package ru.yandex.direct.operation.tree;

import java.util.List;
import java.util.function.Function;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

public final class ListSubOperationExecutorBuilder {

    protected ListSubOperationExecutorBuilder() {
    }

    public final <FP extends Model> FakeParentsStep<FP> withFakeParents(List<FP> fakeParents) {
        return new FakeParentsStep<>(fakeParents);
    }

    public static final class FakeParentsStep<FP extends Model> {
        private List<FP> fakeParents;

        private FakeParentsStep(List<FP> fakeParents) {
            this.fakeParents = fakeParents;
        }

        public <FC extends Model> FakeChildrenStep<FP, FC> withFakeChildrenProperty(
                ModelProperty<? super FP, List<FC>> fakeChildrenProperty) {
            return new FakeChildrenStep<>(fakeParents, fakeChildrenProperty);
        }

        public <C extends Model> ChildrenStep<FP, C, C> withChildrenProperty(
                ModelProperty<? super FP, List<C>> childrenProperty) {
            return new ChildrenStep<>(fakeParents, childrenProperty, Function.identity());
        }
    }


    public static final class FakeChildrenStep<FP extends Model, FC extends Model> {
        private List<FP> fakeParents;
        private ModelProperty<? super FP, List<FC>> fakeChildrenProperty;

        private FakeChildrenStep(List<FP> fakeParents, ModelProperty<? super FP, List<FC>> fakeChildrenProperty) {
            this.fakeParents = fakeParents;
            this.fakeChildrenProperty = fakeChildrenProperty;
        }

        public <C> ChildrenStep<FP, FC, C> withRealChildProperty(
                ModelProperty<? super FC, C> fakeChildToRealChildProperty) {
            return new ChildrenStep<>(fakeParents, fakeChildrenProperty, fakeChildToRealChildProperty::get);
        }
    }


    public static final class ChildrenStep<FP extends Model, FC extends Model, C> {
        private List<FP> fakeParents;
        private ModelProperty<? super FP, List<FC>> fakeChildrenProperty;
        private Function<FC, C> fakeChildToRealChildFn;

        private ChildrenStep(List<FP> fakeParents, ModelProperty<? super FP, List<FC>> fakeChildrenProperty,
                             Function<FC, C> fakeChildToRealChildFn) {
            this.fakeParents = fakeParents;
            this.fakeChildrenProperty = fakeChildrenProperty;
            this.fakeChildToRealChildFn = fakeChildToRealChildFn;
        }

        public <P, SO extends SubOperation<C>> ListSubOperationExecutor<P, C, SO> createSubOperationBy(
                SubOperationCreator<FC, SO> operationCreator) {
            return ListSubOperationExecutor.create(fakeParents, fakeChildrenProperty,
                    fakeChildToRealChildFn, operationCreator);
        }
    }
}
