package ru.yandex.direct.operation.update;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

public interface ModelChangesValidatedStep<M extends ModelWithId> {

    List<ModelChanges<M>> getModelChanges();

    ValidationResult<List<ModelChanges<M>>, Defect> getModelChangesValidationResult();

    void setModelChangesValidationResult(
            ValidationResult<List<ModelChanges<M>>, Defect> modelChangesValidationResult);

    Collection<ModelChanges<M>> getValidModelChanges();

    Map<Integer, ModelChanges<M>> getValidModelChangesWithIndex();
}
