package ru.yandex.direct.operation.update;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import java.util.function.Function;

import ru.yandex.direct.model.ModelWithId;

public class ModelStubProvider {
    public static <M extends ModelWithId, T extends M> Function<Long, T> getModelStub(Class<T> modelChangesClass,
                                                                                      Set<Class<? extends M>> modelClasses) {
        for (Class<? extends M> modelClass : modelClasses) {
            if (modelChangesClass.isAssignableFrom(modelClass)) {
                return id -> {
                    try {
                        var newInstance = modelClass.getDeclaredConstructor().newInstance();
                        newInstance.setId(id);
                        // кастовать можно, только что проверили, что runtimeClass implements mc.getModelType(), а он T
                        // noinspection unchecked
                        return (T) newInstance;
                    } catch (InstantiationException | IllegalAccessException | InvocationTargetException
                            | NoSuchMethodException e) {
                        throw new RuntimeException(e);
                    }
                };
            }
        }
        throw new IllegalStateException("model stub not found");
    }
}
