package ru.yandex.direct.operation.update;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.operation.OperationsUtils;

/**
 * Упрощение AbstractUpdateOperation за счет метода execute(Collection<M>).
 * Использовать, когда в операции execute не имеют значения индексы моделей в исходном массиве.
 *
 * @param <M> тип модели
 * @param <R> тип результата
 */
public abstract class SimpleAbstractUpdateOperation<M extends ModelWithId, R> extends AbstractUpdateOperation<M, R> {

    public SimpleAbstractUpdateOperation(Applicability applicability,
                                         List<ModelChanges<M>> modelChanges,
                                         Function<Long, M> modelStubCreator) {
        super(applicability, modelChanges, modelStubCreator);
    }

    public SimpleAbstractUpdateOperation(Applicability applicability,
                                         List<ModelChanges<M>> modelChanges,
                                         Function<Long, M> modelStubCreator,
                                         Set<ModelProperty<?, ?>> sensitiveProperties) {
        super(applicability, modelChanges, modelStubCreator, sensitiveProperties);
    }

    public SimpleAbstractUpdateOperation(Applicability applicability,
                                         List<ModelChanges<M>> modelChanges,
                                         Function<Long, M> modelStubCreator,
                                         Set<ModelProperty<?, ?>> sensitiveProperties,
                                         Map<ModelProperty<? super M, ?>, BiFunction<Object, Object, Boolean>> customModelEquals) {
        super(applicability, modelChanges, modelStubCreator, sensitiveProperties, customModelEquals);
    }

    @Override
    protected Map<Integer, R> execute(ExecutionStep<M> executionStep) {
        return OperationsUtils.applyForMapValues(executionStep.getAppliedChangesForExecutionWithIndex(), this::execute);
    }

    /**
     * Сохранение валидных изменений. Метод необходимо реализовать в потомке.
     *
     * @param applicableAppliedChanges список валидных AppliedChanges.
     * @return список результатов, соответствующий по размеру входной коллекции
     */
    protected abstract List<R> execute(List<AppliedChanges<M>> applicableAppliedChanges);
}
