package ru.yandex.direct.organizations.swagger;

import java.util.Objects;
import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import static java.util.Collections.emptySet;
import static ru.yandex.direct.utils.CommonUtils.nvl;

/**
 * Расширенный вариант {@link OrganizationInfo} для использования в API.
 * Добавляет к информации наличие склеенных пермалинков.
 */
@ParametersAreNonnullByDefault
public class OrganizationApiInfo extends OrganizationInfo {
    /**
     * Пермалинки, склеенные с этой организацией.
     */
    private Set<Long> mergedPermalinks;

    public Set<Long> getMergedPermalinks() {
        return nvl(mergedPermalinks, emptySet());
    }

    public OrganizationApiInfo withMergedPermalinks(Set<Long> mergedPermalinks) {
        this.mergedPermalinks = mergedPermalinks;
        return this;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OrganizationApiInfo that = (OrganizationApiInfo) o;
        return Objects.equals(mergedPermalinks, that.mergedPermalinks);
    }

    @Override
    public int hashCode() {
        return Objects.hash(
                super.hashCode(),
                mergedPermalinks
        );
    }
}
