package ru.yandex.direct.organizations.swagger;

import java.util.List;
import java.util.Objects;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.organization.model.Organization;
import ru.yandex.direct.organizations.swagger.model.Address;
import ru.yandex.direct.organizations.swagger.model.CompanyPhone;
import ru.yandex.direct.organizations.swagger.model.MetrikaData;
import ru.yandex.direct.organizations.swagger.model.WorkInterval;

@ParametersAreNonnullByDefault
public class OrganizationInfo extends Organization {
    @Nullable
    private Address address;
    @Nonnull
    private String companyName;
    @Nullable
    private CompanyPhone phone;
    @Nonnull
    private List<CompanyPhone> phones;
    @Nullable
    private String profileUrl;
    @Nullable
    private String cabinetUrl;
    @Nonnull
    private List<WorkInterval> workIntervals;
    @Nullable
    private String email;
    @Nullable
    private String rubric;
    @Nonnull
    private List<String> urls;
    @Nullable
    private Boolean isOnline;
    @Nullable
    private MetrikaData metrikaData;
    @Nullable
    private String previewHref;

    @Nullable
    public Address getAddress() {
        return address;
    }

    public OrganizationInfo withAddress(@Nullable Address address) {
        this.address = address;
        return this;
    }

    @Nullable
    public String getCompanyName() {
        return companyName;
    }

    public OrganizationInfo withCompanyName(@Nullable String companyName) {
        this.companyName = companyName;
        return this;
    }

    @Nullable
    public CompanyPhone getPhone() {
        return phone;
    }

    public OrganizationInfo withPhone(@Nullable CompanyPhone phone) {
        this.phone = phone;
        return this;
    }

    @Nonnull
    public List<CompanyPhone> getPhones() {
        return phones;
    }

    public OrganizationInfo withPhones(List<CompanyPhone> phones) {
        this.phones = phones;
        return this;
    }

    @Nullable
    public String getProfileUrl() {
        return profileUrl;
    }

    public OrganizationInfo withProfileUrl(@Nullable String profileUrl) {
        this.profileUrl = profileUrl;
        return this;
    }

    @Nullable
    public String getCabinetUrl() {
        return cabinetUrl;
    }

    public OrganizationInfo withCabinetUrl(@Nullable String cabinetUrl) {
        this.cabinetUrl = cabinetUrl;
        return this;
    }

    @Nonnull
    public List<WorkInterval> getWorkIntervals() {
        return workIntervals;
    }

    public OrganizationInfo withWorkIntervals(@Nonnull List<WorkInterval> workIntervals) {
        this.workIntervals = workIntervals;
        return this;
    }

    @Nullable
    public String getEmail() {
        return email;
    }

    public OrganizationInfo withEmail(@Nullable String email) {
        this.email = email;
        return this;
    }

    @Nullable
    public String getRubric() {
        return rubric;
    }

    public OrganizationInfo withRubric(@Nullable String rubric) {
        this.rubric = rubric;
        return this;
    }

    @Nonnull
    public List<String> getUrls() {
        return urls;
    }

    public OrganizationInfo withUrls(List<String> urls) {
        this.urls = urls;
        return this;
    }

    @Nullable
    public Boolean getIsOnline() {
        return isOnline;
    }

    public OrganizationInfo withIsOnline(Boolean isOnline) {
        this.isOnline = isOnline;
        return this;
    }

    @Nullable
    public MetrikaData getMetrikaData() {
        return metrikaData;
    }

    public OrganizationInfo withMetrikaData(@Nullable MetrikaData metrikaData) {
        this.metrikaData = metrikaData;
        return this;
    }

    @Nullable
    public String getPreviewHref() {
        return previewHref;
    }

    public OrganizationInfo withPreviewHref(@Nullable String previewHref) {
        this.previewHref = previewHref;
        return this;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OrganizationInfo that = (OrganizationInfo) o;
        return Objects.equals(address, that.address)
                && Objects.equals(companyName, that.companyName)
                && Objects.equals(phone, that.phone)
                && Objects.equals(phones, that.phones)
                && Objects.equals(profileUrl, that.profileUrl)
                && Objects.equals(cabinetUrl, that.cabinetUrl)
                && Objects.equals(workIntervals, that.workIntervals)
                && Objects.equals(email, that.email)
                && Objects.equals(rubric, that.rubric)
                && Objects.equals(urls, that.urls)
                && Objects.equals(isOnline, that.isOnline)
                && Objects.equals(metrikaData, that.metrikaData)
                && Objects.equals(previewHref, that.previewHref);
    }

    @Override
    public int hashCode() {
        return Objects.hash(
                super.hashCode(),
                address,
                companyName,
                phone,
                phones,
                profileUrl,
                cabinetUrl,
                workIntervals,
                email,
                rubric,
                urls,
                isOnline,
                metrikaData,
                previewHref
        );
    }
}
