package ru.yandex.direct.organizations.swagger

import org.asynchttpclient.Response
import ru.yandex.direct.http.smart.converter.CustomJsonResponseConverter
import ru.yandex.direct.organizations.swagger.model.CompanyValidationResult
import ru.yandex.direct.organizations.swagger.model.PubApiCompany
import ru.yandex.direct.organizations.swagger.model.SpravResponse
import ru.yandex.direct.organizations.util.ConverterHelper.Companion.OBJECT_MAPPER_TOLERANT_TO_UNKNOWN
import java.lang.reflect.Type
import java.nio.charset.StandardCharsets

class PubApiCompanyResponseConverter : CustomJsonResponseConverter<SpravResponse<PubApiCompany>>() {
    override fun buildObjectMapper() = OBJECT_MAPPER_TOLERANT_TO_UNKNOWN

    override fun convert(response: Response, responseType: Type?): SpravResponse<PubApiCompany> {
        return when (response.statusCode) {
            201 -> SpravResponse.successful(parseSuccess(response))
            422 -> SpravResponse.error(parseValidationResult(response))
            else -> throw IllegalArgumentException("Unexpected status code ${response.statusCode}")
        }
    }

    private fun parseSuccess(response: Response): PubApiCompany {
        val responseBody = response.getResponseBody(StandardCharsets.UTF_8)
        return objectMapper.readValue(responseBody, PubApiCompany::class.java)
    }

    private fun parseValidationResult(response: Response): CompanyValidationResult {
        val responseBody = response.getResponseBody(StandardCharsets.UTF_8)
        return objectMapper.readValue(responseBody, CompanyValidationResult::class.java)
    }
}
