package ru.yandex.direct.organizations.swagger

import org.asynchttpclient.Response
import org.slf4j.LoggerFactory
import ru.yandex.direct.http.smart.converter.CustomJsonResponseConverter
import ru.yandex.direct.organizations.swagger.model.UpdateOrganizationResponse
import ru.yandex.direct.utils.JsonUtils
import java.lang.reflect.Type
import java.nio.charset.StandardCharsets

private val logger = LoggerFactory.getLogger(UpdateOrganizationResponseConverter::class.java)

class UpdateOrganizationResponseConverter : CustomJsonResponseConverter<UpdateOrganizationResponse>() {
    override fun buildObjectMapper() = JsonUtils.MAPPER.copy()

    override fun convert(response: Response, responseType: Type?): UpdateOrganizationResponse? {
        val responseBody = response.getResponseBody(StandardCharsets.UTF_8)
        return when (response.statusCode) {
            200 -> objectMapper.readValue(responseBody, UpdateOrganizationResponse::class.java)
            204 -> UpdateOrganizationResponse()
            else -> {
                logger.error("Failed to update organization: $response")
                null
            }
        }
    }
}
