package ru.yandex.direct.organizations.swagger.model

data class CreateOnlineOrgRequest(
    val creatorUid: Long,
    val name: String,
    val phoneFormatted: String,
    val url: String?,
    val serviceAreaGeoIds: List<Long>,
    val rubricsIds: List<Long>,
) {
    fun toPubApiCreateCompanyRequest(permalinkId: Long): PubApiCreateCompanyRequest {
        return PubApiCreateCompanyRequest().apply {
            requester = RequesterData().apply {
                uid = creatorUid
            }
            company = PubApiCompany().apply {
                id = permalinkId
                isIsOnline = true
                serviceArea = CompanyServiceArea().apply {
                    geoIds = serviceAreaGeoIds
                    isHideAddress = true
                }
                names = listOf(
                    CompanyName().apply {
                        value = LocalizedString().apply {
                            value = name
                            locale = "ru" // для простоты используем русскую локаль
                        }
                    }
                )
                phones = listOf(
                    CompanyPhone().apply {
                        formatted(phoneFormatted)
                    }
                )
                if (url != null) {
                    urls = listOf(
                        CompanyUrl().apply {
                            value = url
                        }
                    )
                }
                rubrics = rubricsIds.mapIndexed { idx, rubricId ->
                    CompanyRubric().apply {
                        this.rubricId = rubricId
                        if (idx == 0) {
                            isIsMain = true
                        }
                    }
                }
            }
        }
    }
}
