package ru.yandex.direct.organizations.swagger.model

/**
 * Удобная обёртка для хранения ответа внешнего сервиса.
 *
 * Если сервис имеет свою валидацию запроса, то он может вернуть 4xx ошибку. Формат этого сообщения обычно отличается
 * от успешного ответа. [Response] содержит в себе или успешный ответ, или описание ошибки
 */
open class Response<V, E> {
    val success: V?
    val error: E?

    internal constructor(
        success: V? = null,
        error: E? = null,
    ) {
        check((success == null) xor (error == null)) { "Exactly one argument should be not null" }
        this.success = success
        this.error = error
    }

    fun onSuccess(
        consumer: (value: V) -> Unit
    ) {
        success?.let(consumer)
    }

    fun <R> fold(
        onSuccess: (value: V) -> R,
        onFailure: (error: E) -> R
    ): R {
        return if (success != null) {
            onSuccess(success)
        } else {
            onFailure(error!!)
        }
    }

    override fun toString() = "${javaClass.simpleName}(success=$success, error=$error)"
}
