package ru.yandex.direct.organizations.swagger.model

class SpravResponse<V>(
    success: V? = null,
    error: CompanyValidationResult? = null,
) : Response<V, CompanyValidationResult>(success, error) {
    companion object {
        fun <V> successful(success: V?): SpravResponse<V> =
            SpravResponse(success)

        fun <V> error(error: CompanyValidationResult?): SpravResponse<V> =
            SpravResponse(error = error)
    }
}
