package ru.yandex.direct.organizations.util

import com.fasterxml.jackson.core.JsonParser
import com.fasterxml.jackson.databind.DeserializationContext
import com.fasterxml.jackson.databind.DeserializationFeature
import com.fasterxml.jackson.databind.ObjectMapper
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler
import com.fasterxml.jackson.databind.deser.ValueInstantiator
import ru.yandex.direct.utils.JsonUtils
import java.io.IOException

class ConverterHelper {
    companion object {
        /**
         * [ObjectMapper], который не рушается на неизвестные поля и значения enum'ов.
         * Удобен в конвертерах [ru.yandex.direct.organizations.swagger.OrganizationsClient],
         * так как используются устаревшие модели
         */
        @JvmField
        val OBJECT_MAPPER_TOLERANT_TO_UNKNOWN = createDefaultMapper();

        private fun createDefaultMapper(): ObjectMapper {
            return JsonUtils.MAPPER.copy().apply {
                enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)
                disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)
                addHandler(object : DeserializationProblemHandler() {
                    @Throws(IOException::class)
                    override fun handleMissingInstantiator(
                        ctxt: DeserializationContext, instClass: Class<*>?,
                        valueInsta: ValueInstantiator, p: JsonParser, msg: String
                    ): Any? {
                        return null
                    }
                })
            }
        }
    }
}
