package ru.yandex.direct.organizations.util;

import java.util.List;
import java.util.Map;

import ru.yandex.direct.organizations.swagger.model.PubApiCompaniesData;

public class OrganizationUtils {

    public static PubApiCompaniesData mergePubApiCompaniesData(List<PubApiCompaniesData> list) {
        PubApiCompaniesData result = new PubApiCompaniesData();
        list.forEach(item -> {
            result.setCompanies(mergeList(result.getCompanies(), item.getCompanies()));
            result.setRegionalChains(mergeList(result.getRegionalChains(), item.getRegionalChains()));

            result.setChainDefs(mergeMap(result.getChainDefs(), item.getChainDefs()));
            result.setFeatureDefs(mergeMap(result.getFeatureDefs(), item.getFeatureDefs()));
            result.setGeoidDefs(mergeMap(result.getGeoidDefs(), item.getGeoidDefs()));
            result.setRubricDefs(mergeMap(result.getRubricDefs(), item.getRubricDefs()));
        });
        return result;
    }

    private static <T> List<T> mergeList(List<T> right, List<T> left) {
        if (left == null) {
            return right;
        } else if (right == null) {
            return left;
        }
        right.addAll(left);
        return right;
    }

    private static <K, V> Map<K, V> mergeMap(Map<K, V> right, Map<K, V> left) {
        if (left == null) {
            return right;
        } else if (right == null) {
            return left;
        }
        right.putAll(left);
        return right;
    }
}
